/*******************************************************************************
*
* Copyright (c) 2015-2016 Intel Corporation.  All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses.  You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* COPYING in the main directory of this source tree, or the
* OpenFabrics.org BSD license below:
*
*   Redistribution and use in source and binary forms, with or
*   without modification, are permitted provided that the following
*   conditions are met:
*
*    - Redistributions of source code must retain the above
*	copyright notice, this list of conditions and the following
*	disclaimer.
*
*    - Redistributions in binary form must reproduce the above
*	copyright notice, this list of conditions and the following
*	disclaimer in the documentation and/or other materials
*	provided with the distribution.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
* BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
* ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
*******************************************************************************/

#include "kcompat.h"

/*****************************************************************************/
struct dst_entry *i40iw_get_fl6_dst(struct sockaddr_in6 *src_addr,
					struct sockaddr_in6 *dst_addr)
{
	struct dst_entry *dst = NULL;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 39)
	struct flowi6 fl6;
	memset(&fl6, 0, sizeof(fl6));
	fl6.daddr = dst_addr->sin6_addr;
	fl6.saddr = src_addr->sin6_addr;
	if (ipv6_addr_type(&fl6.daddr) & IPV6_ADDR_LINKLOCAL)
		fl6.flowi6_oif = dst_addr->sin6_scope_id;

	dst = ip6_route_output(&init_net, NULL, &fl6);
#else
	struct flowi fl;
	memset(&fl, 0, sizeof fl);
	ipv6_addr_copy(&fl.fl6_dst, &dst_addr->sin6_addr);
	ipv6_addr_copy(&fl.fl6_src, &src_addr->sin6_addr);
	if (ipv6_addr_type(&fl.fl6_dst) & IPV6_ADDR_LINKLOCAL)
		fl.oif = dst_addr->sin6_scope_id;

	dst = ip6_route_output(&init_net, NULL, &fl);
#endif
	return dst;
}

struct neighbour *i40iw_get_neigh_ipv6(struct dst_entry *dst,
					struct sockaddr_in6 *dst_ipaddr)
{
	struct neighbour *neigh = NULL;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(3, 1, 0)
	neigh = dst_neigh_lookup(dst, dst_ipaddr);
#elif LINUX_VERSION_CODE > KERNEL_VERSION(3, 0, 0)
	neigh = dst->_neighbour;
#else
	neigh = dst->neighbour;
#endif
	return neigh;
}

struct neighbour *i40iw_get_neigh_ipv4(struct rtable *rt, __be32 *dst_ipaddr)
{
	struct neighbour *neigh = NULL;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(3, 1, 0)
	neigh = dst_neigh_lookup(&rt->dst, dst_ipaddr);
#elif LINUX_VERSION_CODE > KERNEL_VERSION(3, 0, 0)
	neigh = rt->dst._neighbour;
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 39)
	neigh = rt->u.dst.neighbour;
#else
	neigh = rt->dst.neighbour;
#endif
	return neigh;
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 9, 0)
struct net_device *i40iw_netdev_master_upper_dev_get(struct net_device *netdev)
{
	return netdev->master;
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 39)
struct rtable *i40iw_ip_route_output(struct net *net, __be32 daddr,
					__be32 saddr, u8 tos, int oif)
{
	struct flowi fl;
	struct rtable *rt;
	int ret;

	memset(&fl, 0, sizeof(fl));
	fl.nl_u.ip4_u.daddr = daddr;
	fl.nl_u.ip4_u.saddr = saddr;
	fl.oif = oif;
	ret = ip_route_output_key(net, &rt, &fl);
	return rt;
}
#endif

#endif
