################################################################################
#
# * Copyright (c) 2015-2016 Intel Corporation.  All rights reserved.
# *
# * This software is available to you under a choice of one of two
# * licenses.  You may choose to be licensed under the terms of the GNU
# * General Public License (GPL) Version 2, available from the file
# * COPYING in the main directory of this source tree, or the
# * OpenFabrics.org BSD license below:
# *
# *   Redistribution and use in source and binary forms, with or
# *   without modification, are permitted provided that the following
# *   conditions are met:
# *
# *    - Redistributions of source code must retain the above
# *	copyright notice, this list of conditions and the following
# *	disclaimer.
# *
# *    - Redistributions in binary form must reproduce the above
# *	copyright notice, this list of conditions and the following
# *	disclaimer in the documentation and/or other materials
# *	provided with the distribution.
# *
# * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# * SOFTWARE.
#
################################################################################

#!/bin/bash
if [ -e /etc/SuSE-release ]; then

if [ -e /lib/modules/`uname -r`/build/include/config ]; then
	KSRC="/lib/modules/`uname -r`/build/"
	USE_KTHREAD="y"
fi

export USE_KTHREAD

if [ -x /sbin/depmod ]; then
	RUN_DEPMOD=/sbin/depmod
fi

else

if [ -e /usr/src/kernels/linux-`uname -r`/include/config ]; then
        KSRC="/usr/src/kernels/linux-`uname -r`/"
elif [ -e /usr/src/kernels/`uname -r`/include/config ]; then
        KSRC="/usr/src/kernels/`uname -r`/"
fi

fi

export KSRC

make -C $KSRC I40E_SRC=$1 M=$PWD/src/i40iw clean
make -C $KSRC I40E_SRC=$1 M=$PWD/src/i40iw
make -C $KSRC M=$PWD/src/i40iw  modules_install

if [ -n "$RUN_DEPMOD" ]; then
	KVERSION=`uname -r`
	$RUN_DEPMOD $KVERSION
fi
